<div class="relative overflow-x-auto bg-white shadow-md dark:bg-gray-800 sm:rounded-lg">
    <div class="flex flex-col items-center justify-between p-4 space-y-3 md:flex-row md:space-y-0 md:space-x-4">
        <div class="w-full md:w-1/2">
            <form class="flex items-center">
                <label for="subscriptions-search" class="sr-only">{{ __('common.search') }}</label>
                <div class="relative w-full">
                    <div class="absolute inset-y-0 start-0 flex items-center ps-3 pointer-events-none">
                        <svg aria-hidden="true" class="w-5 h-5 text-gray-500 dark:text-gray-400" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd" />
                        </svg>
                    </div>
                    <input type="text"
                           wire:model.live.debounce.300ms="search"
                           id="subscriptions-search"
                           class="block w-full p-2 ps-10 text-sm text-gray-900 border border-gray-300 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                           placeholder="{{ __('common.search') }}">
                </div>
            </form>
        </div>
        <div class="flex flex-col items-stretch justify-end flex-shrink-0 w-full space-y-2 md:w-auto md:flex-row md:space-y-0 md:items-center md:space-x-3">
            <div class="flex items-center w-full space-x-3 md:w-auto">
                <button id="filterDropdownButton" data-dropdown-toggle="filterDropdown" type="button" class="flex items-center justify-center w-full px-4 py-2 text-sm font-medium text-gray-900 bg-white border border-gray-200 rounded-lg md:w-auto focus:outline-hidden hover:bg-gray-100 hover:text-blue-700 focus:z-10 focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700 dark:bg-gray-800 dark:text-gray-400 dark:border-gray-600 dark:hover:text-white dark:hover:bg-gray-700">
                    <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" class="w-4 h-4 me-2 text-gray-400" viewBox="0 0 20 20" fill="currentColor">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 011-1h12a1 1 0 011 1v3a1 1 0 01-.293.707L12 11.414V15a1 1 0 01-.293.707l-2 2A1 1 0 018 17v-5.586L3.293 6.707A1 1 0 013 6V3z" clip-rule="evenodd" />
                    </svg>
                    {{ __('common.filter') }}
                    <svg class="-me-1 ms-1.5 w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
                        <path clip-rule="evenodd" fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" />
                    </svg>
                </button>
                <div id="filterDropdown" class="z-10 hidden w-48 p-3 bg-white rounded-lg shadow dark:bg-gray-700">
                    <h6 class="mb-3 text-sm font-medium text-gray-900 dark:text-white">{{ __('common.status') }}</h6>
                    <ul class="space-y-2 text-sm" aria-labelledby="filterDropdownButton">
                        <li class="flex items-center">
                            <input id="sub-status-active" type="checkbox" wire:model.live="statusFilter" value="active" class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-blue-600 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                            <label for="sub-status-active" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('common.active') }}</label>
                        </li>
                        <li class="flex items-center">
                            <input id="sub-status-pending" type="checkbox" wire:model.live="statusFilter" value="pending" class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-blue-600 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                            <label for="sub-status-pending" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('common.pending') }}</label>
                        </li>
                        <li class="flex items-center">
                            <input id="sub-status-expired" type="checkbox" wire:model.live="statusFilter" value="expired" class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-blue-600 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                            <label for="sub-status-expired" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ __('admin.status_expired') }}</label>
                        </li>
                    </ul>
                    <h6 class="mt-4 mb-3 text-sm font-medium text-gray-900 dark:text-white">{{ __('common.plan') }}</h6>
                    <ul class="space-y-2 text-sm" aria-labelledby="filterDropdownButton">
                        @foreach($plans as $plan)
                        <li class="flex items-center">
                            <input id="plan-{{ Str::slug($plan->name) }}" type="checkbox" wire:model.live="planFilter" value="{{ $plan->name }}" class="w-4 h-4 bg-gray-100 border-gray-300 rounded text-blue-600 focus:ring-blue-500 dark:focus:ring-blue-600 dark:ring-offset-gray-700 dark:focus:ring-offset-gray-700 focus:ring-2 dark:bg-gray-600 dark:border-gray-500">
                            <label for="plan-{{ Str::slug($plan->name) }}" class="ms-2 text-sm font-medium text-gray-900 dark:text-gray-100">{{ $plan->name }}</label>
                        </li>
                        @endforeach
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <table class="w-full text-sm text-left rtl:text-right text-gray-500 dark:text-gray-400">
        <thead class="text-xs text-gray-700 uppercase bg-gray-50 dark:bg-gray-700 dark:text-gray-400">
            <tr>
                <th scope="col" class="px-6 py-3">{{ __('common.user') }}</th>
                <th scope="col" class="px-6 py-3">{{ __('common.plan') }}</th>
                <th scope="col" class="px-6 py-3">{{ __('common.status') }}</th>
                <th scope="col" class="px-6 py-3">{{ __('common.amount') }}</th>
                <th scope="col" class="px-6 py-3">{{ __('admin.next_billing') }}</th>
                <th scope="col" class="px-6 py-3">{{ __('common.actions') }}</th>
            </tr>
        </thead>
        <tbody>
            @forelse($subscriptions as $subscription)
                <tr class="bg-white border-b dark:bg-gray-800 dark:border-gray-700 border-gray-200 hover:bg-gray-50 dark:hover:bg-gray-600">
                    <td class="px-6 py-4 font-medium text-gray-900 dark:text-white">{{ $subscription->user->email }}</td>
                    <td class="px-6 py-4">{{ $subscription->plan->name ?? __('admin.no_plan') }}</td>
                    <td class="px-6 py-4">
                        @if($subscription->status === 'active')
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300">{{ __('common.active') }}</span>
                        @elseif($subscription->status === 'pending')
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-300">{{ __('common.pending') }}</span>
                        @else
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded text-xs font-medium bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300">{{ __('admin.status_expired') }}</span>
                        @endif
                    </td>
                    <td class="px-6 py-4">{{ \App\Helpers\CurrencyHelper::format($subscription->amount) }}{{ __('admin.per_month') }}</td>
                    <td class="px-6 py-4">
                        @if($subscription->renewal_at)
                            {{ $subscription->renewal_at->format('M j, Y') }}
                        @else
                            <span class="text-gray-500 dark:text-gray-400">{{ __('common.n_a') }}</span>
                        @endif
                    </td>
                    <td class="px-6 py-4">
                        @if($subscription->status === 'active')
                            <button wire:click="$dispatch('cancel-subscription', { id: {{ $subscription->id }}, user: '{{ addslashes($subscription->user->email) }}' })"
                                    class="text-red-600 hover:text-red-800 dark:text-red-400 hover:underline">
                                {{ __('common.cancel') }}
                            </button>
                        @else
                            <span class="text-gray-400 dark:text-gray-500">—</span>
                        @endif
                    </td>
                </tr>
            @empty
                <tr class="bg-white dark:bg-gray-800">
                    <td colspan="6" class="px-6 py-4 text-center text-gray-500 dark:text-gray-400">
                        {{ __('admin.no_subscriptions_found') }}
                    </td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <!-- Pagination -->
    <x-table-pagination :paginator="$subscriptions" />
</div>
