<div>
    <!-- Modal backdrop -->
    <div x-data="{ show: @entangle('showModal') }"
         x-show="show"
         x-cloak
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 z-50 overflow-y-auto"
         aria-labelledby="modal-title"
         role="dialog"
         aria-modal="true">

        <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
            <!-- Background overlay -->
            <div class="fixed inset-0 transition-opacity bg-gray-500/75 dark:bg-gray-900/75"
                 @click="$wire.closeModal()"
                 aria-hidden="true"></div>

            <!-- Center modal -->
            <span class="hidden sm:inline-block sm:align-middle sm:h-screen" aria-hidden="true">&#8203;</span>

            <!-- Modal panel -->
            <div x-show="show"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                 x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                 x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                 class="relative z-10 inline-block w-full max-w-2xl p-6 my-8 overflow-hidden text-start align-middle transition-all transform bg-white dark:bg-gray-800 shadow-xl rounded-lg">

                <!-- Modal header -->
                <div class="flex items-center justify-between pb-4 mb-4 border-b border-gray-200 dark:border-gray-700">
                    <h3 class="text-xl font-semibold text-gray-900 dark:text-white">
                        {{ $languageId ? __('admin.edit_language') : __('admin.add_new_language') }}
                    </h3>
                    <button type="button"
                            wire:click="closeModal"
                            class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ms-auto inline-flex items-center dark:hover:bg-gray-700 dark:hover:text-white">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z" clip-rule="evenodd"/>
                        </svg>
                    </button>
                </div>

                <!-- Modal body -->
                <form wire:submit="save">
                    <div class="space-y-4 mb-4">
                        <!-- Name -->
                        <div>
                            <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                {{ __('admin.language_name') }} <span class="text-red-500">*</span>
                            </label>
                            <input type="text"
                                   wire:model="name"
                                   id="name"
                                   class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
                                   placeholder="{{ __('admin.language_name_placeholder') }}">
                            @error('name')
                                <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- Code -->
                            <div>
                                <label for="code" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.language_code') }} <span class="text-red-500">*</span>
                                </label>
                                <select wire:model="code"
                                        id="code"
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="">{{ __('common.select') }}</option>
                                    @foreach($availableLanguageCodes as $langCode => $langLabel)
                                        <option value="{{ $langCode }}">{{ $langCode }} ({{ $langLabel }})</option>
                                    @endforeach
                                </select>
                                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.language_code_from_folder') }}</p>
                                @error('code')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @enderror
                            </div>

                            <!-- Flag (Country Code) -->
                            <div>
                                <label for="flag" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.language_flag') }} <span class="text-red-500">*</span>
                                </label>
                                <div class="flex items-center gap-3">
                                    <div class="w-12 h-12 bg-gray-100 dark:bg-gray-700 rounded-lg flex items-center justify-center overflow-hidden border border-gray-300 dark:border-gray-600 flex-shrink-0">
                                        @if($flag)
                                            <span class="fi fi-{{ strtolower($flag) }} text-3xl rounded"></span>
                                        @else
                                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 21v-4m0 0V5a2 2 0 012-2h6.5l1 1H21l-3 6 3 6h-8.5l-1-1H5a2 2 0 00-2 2zm9-13.5V9"/>
                                            </svg>
                                        @endif
                                    </div>
                                    <div class="flex-1" x-data="{
                                        open: false,
                                        search: '',
                                        selected: @entangle('flag'),
                                        dropdownPosition: { top: 0, left: 0, width: 0 },
                                        countries: {
                                            'dz': 'Algeria', 'ao': 'Angola', 'bj': 'Benin', 'bw': 'Botswana', 'bf': 'Burkina Faso',
                                            'bi': 'Burundi', 'cv': 'Cabo Verde', 'cm': 'Cameroon', 'cf': 'Central African Republic',
                                            'td': 'Chad', 'km': 'Comoros', 'cg': 'Congo', 'cd': 'Congo (DRC)', 'ci': 'Côte d\'Ivoire',
                                            'dj': 'Djibouti', 'eg': 'Egypt', 'gq': 'Equatorial Guinea', 'er': 'Eritrea', 'sz': 'Eswatini',
                                            'et': 'Ethiopia', 'ga': 'Gabon', 'gm': 'Gambia', 'gh': 'Ghana', 'gn': 'Guinea',
                                            'gw': 'Guinea-Bissau', 'ke': 'Kenya', 'ls': 'Lesotho', 'lr': 'Liberia', 'ly': 'Libya',
                                            'mg': 'Madagascar', 'mw': 'Malawi', 'ml': 'Mali', 'mr': 'Mauritania', 'mu': 'Mauritius',
                                            'ma': 'Morocco', 'mz': 'Mozambique', 'na': 'Namibia', 'ne': 'Niger', 'ng': 'Nigeria',
                                            'rw': 'Rwanda', 'st': 'São Tomé and Príncipe', 'sn': 'Senegal', 'sc': 'Seychelles',
                                            'sl': 'Sierra Leone', 'so': 'Somalia', 'za': 'South Africa', 'ss': 'South Sudan',
                                            'sd': 'Sudan', 'tz': 'Tanzania', 'tg': 'Togo', 'tn': 'Tunisia', 'ug': 'Uganda',
                                            'zm': 'Zambia', 'zw': 'Zimbabwe',
                                            'ai': 'Anguilla', 'ag': 'Antigua and Barbuda', 'ar': 'Argentina', 'aw': 'Aruba',
                                            'bs': 'Bahamas', 'bb': 'Barbados', 'bz': 'Belize', 'bm': 'Bermuda', 'bo': 'Bolivia',
                                            'br': 'Brazil', 'ca': 'Canada', 'ky': 'Cayman Islands', 'cl': 'Chile', 'co': 'Colombia',
                                            'cr': 'Costa Rica', 'cu': 'Cuba', 'cw': 'Curaçao', 'dm': 'Dominica', 'do': 'Dominican Republic',
                                            'ec': 'Ecuador', 'sv': 'El Salvador', 'gf': 'French Guiana', 'gl': 'Greenland', 'gd': 'Grenada',
                                            'gp': 'Guadeloupe', 'gt': 'Guatemala', 'gy': 'Guyana', 'ht': 'Haiti', 'hn': 'Honduras',
                                            'jm': 'Jamaica', 'mq': 'Martinique', 'mx': 'Mexico', 'ms': 'Montserrat', 'ni': 'Nicaragua',
                                            'pa': 'Panama', 'py': 'Paraguay', 'pe': 'Peru', 'pr': 'Puerto Rico', 'kn': 'Saint Kitts and Nevis',
                                            'lc': 'Saint Lucia', 'vc': 'Saint Vincent and the Grenadines', 'sx': 'Sint Maarten',
                                            'sr': 'Suriname', 'tt': 'Trinidad and Tobago', 'tc': 'Turks and Caicos Islands',
                                            'us': 'United States', 'vi': 'U.S. Virgin Islands', 'uy': 'Uruguay', 've': 'Venezuela',
                                            'af': 'Afghanistan', 'am': 'Armenia', 'az': 'Azerbaijan', 'bh': 'Bahrain', 'bd': 'Bangladesh',
                                            'bt': 'Bhutan', 'bn': 'Brunei', 'kh': 'Cambodia', 'cn': 'China', 'ge': 'Georgia',
                                            'hk': 'Hong Kong', 'in': 'India', 'id': 'Indonesia', 'ir': 'Iran', 'iq': 'Iraq',
                                            'il': 'Israel', 'jp': 'Japan', 'jo': 'Jordan', 'kz': 'Kazakhstan', 'kw': 'Kuwait',
                                            'kg': 'Kyrgyzstan', 'la': 'Laos', 'lb': 'Lebanon', 'mo': 'Macau', 'my': 'Malaysia',
                                            'mv': 'Maldives', 'mn': 'Mongolia', 'mm': 'Myanmar', 'np': 'Nepal', 'kp': 'North Korea',
                                            'om': 'Oman', 'pk': 'Pakistan', 'ps': 'Palestine', 'ph': 'Philippines', 'qa': 'Qatar',
                                            'sa': 'Saudi Arabia', 'sg': 'Singapore', 'kr': 'South Korea', 'lk': 'Sri Lanka',
                                            'sy': 'Syria', 'tw': 'Taiwan', 'tj': 'Tajikistan', 'th': 'Thailand', 'tl': 'Timor-Leste',
                                            'tr': 'Turkey', 'tm': 'Turkmenistan', 'ae': 'United Arab Emirates', 'uz': 'Uzbekistan',
                                            'vn': 'Vietnam', 'ye': 'Yemen',
                                            'al': 'Albania', 'ad': 'Andorra', 'at': 'Austria', 'by': 'Belarus', 'be': 'Belgium',
                                            'ba': 'Bosnia and Herzegovina', 'bg': 'Bulgaria', 'hr': 'Croatia', 'cy': 'Cyprus',
                                            'cz': 'Czech Republic', 'dk': 'Denmark', 'ee': 'Estonia', 'fo': 'Faroe Islands',
                                            'fi': 'Finland', 'fr': 'France', 'de': 'Germany', 'gi': 'Gibraltar', 'gr': 'Greece',
                                            'gg': 'Guernsey', 'hu': 'Hungary', 'is': 'Iceland', 'ie': 'Ireland', 'im': 'Isle of Man',
                                            'it': 'Italy', 'je': 'Jersey', 'xk': 'Kosovo', 'lv': 'Latvia', 'li': 'Liechtenstein',
                                            'lt': 'Lithuania', 'lu': 'Luxembourg', 'mk': 'North Macedonia', 'mt': 'Malta',
                                            'md': 'Moldova', 'mc': 'Monaco', 'me': 'Montenegro', 'nl': 'Netherlands', 'no': 'Norway',
                                            'pl': 'Poland', 'pt': 'Portugal', 'ro': 'Romania', 'ru': 'Russia', 'sm': 'San Marino',
                                            'rs': 'Serbia', 'sk': 'Slovakia', 'si': 'Slovenia', 'es': 'Spain', 'se': 'Sweden',
                                            'ch': 'Switzerland', 'ua': 'Ukraine', 'gb': 'United Kingdom', 'va': 'Vatican City',
                                            'as': 'American Samoa', 'au': 'Australia', 'fj': 'Fiji', 'pf': 'French Polynesia',
                                            'gu': 'Guam', 'ki': 'Kiribati', 'mh': 'Marshall Islands', 'fm': 'Micronesia', 'nr': 'Nauru',
                                            'nc': 'New Caledonia', 'nz': 'New Zealand', 'nu': 'Niue', 'pw': 'Palau',
                                            'pg': 'Papua New Guinea', 'ws': 'Samoa', 'sb': 'Solomon Islands', 'to': 'Tonga',
                                            'tv': 'Tuvalu', 'vu': 'Vanuatu'
                                        },
                                        get filteredCountries() {
                                            if (!this.search) return Object.entries(this.countries).sort((a, b) => a[1].localeCompare(b[1]));
                                            const searchLower = this.search.toLowerCase();
                                            return Object.entries(this.countries)
                                                .filter(([code, name]) => name.toLowerCase().includes(searchLower) || code.toLowerCase().includes(searchLower))
                                                .sort((a, b) => a[1].localeCompare(b[1]));
                                        },
                                        get selectedName() {
                                            return this.selected ? this.countries[this.selected] : '';
                                        },
                                        selectCountry(code) {
                                            this.selected = code;
                                            this.open = false;
                                            this.search = '';
                                        },
                                        updatePosition() {
                                            const rect = this.$refs.trigger.getBoundingClientRect();
                                            this.dropdownPosition = {
                                                top: rect.bottom + window.scrollY + 4,
                                                left: rect.left + window.scrollX,
                                                width: rect.width
                                            };
                                        }
                                    }" @click.away="open = false" @keydown.escape.window="open = false">
                                        <!-- Trigger button -->
                                        <button type="button"
                                                x-ref="trigger"
                                                @click="updatePosition(); open = !open; $nextTick(() => { if (open) $refs.searchInput.focus() })"
                                                class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500 text-start flex items-center justify-between">
                                            <span x-show="selected" class="flex items-center gap-2">
                                                <span :class="'fi fi-' + selected" class="rounded"></span>
                                                <span x-text="selectedName"></span>
                                            </span>
                                            <span x-show="!selected" class="text-gray-500 dark:text-gray-400">{{ __('common.select') }}</span>
                                            <svg class="w-4 h-4 ms-2 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
                                            </svg>
                                        </button>

                                        <!-- Dropdown (teleported to body) -->
                                        <template x-teleport="body">
                                            <div x-show="open"
                                                 x-transition:enter="transition ease-out duration-100"
                                                 x-transition:enter-start="opacity-0 scale-95"
                                                 x-transition:enter-end="opacity-100 scale-100"
                                                 x-transition:leave="transition ease-in duration-75"
                                                 x-transition:leave-start="opacity-100 scale-100"
                                                 x-transition:leave-end="opacity-0 scale-95"
                                                 :style="'position: fixed; top: ' + dropdownPosition.top + 'px; left: ' + dropdownPosition.left + 'px; width: ' + dropdownPosition.width + 'px; z-index: 9999;'"
                                                 class="bg-white dark:bg-gray-700 border border-gray-300 dark:border-gray-600 rounded-lg shadow-lg">
                                                <!-- Search input -->
                                                <div class="p-2 border-b border-gray-200 dark:border-gray-600">
                                                    <input type="text"
                                                           x-model="search"
                                                           @click.stop
                                                           x-ref="searchInput"
                                                           @keydown.enter.prevent="if (filteredCountries.length) selectCountry(filteredCountries[0][0])"
                                                           class="w-full px-3 py-2 text-sm border border-gray-300 rounded-lg focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-600 dark:border-gray-500 dark:text-white dark:placeholder-gray-400"
                                                           placeholder="{{ __('common.search') }}...">
                                                </div>
                                                <!-- Options list -->
                                                <ul class="max-h-60 overflow-y-auto py-1">
                                                    <template x-for="[code, name] in filteredCountries" :key="code">
                                                        <li>
                                                            <button type="button"
                                                                    @click="selectCountry(code)"
                                                                    class="w-full px-3 py-2 text-sm text-start hover:bg-gray-100 dark:hover:bg-gray-600 flex items-center gap-2"
                                                                    :class="{ 'bg-blue-50 dark:bg-blue-900/30': selected === code }">
                                                                <span :class="'fi fi-' + code" class="rounded flex-shrink-0"></span>
                                                                <span x-text="name" class="text-gray-900 dark:text-white"></span>
                                                                <span x-text="'(' + code.toUpperCase() + ')'" class="text-gray-500 dark:text-gray-400 text-xs"></span>
                                                            </button>
                                                        </li>
                                                    </template>
                                                    <li x-show="filteredCountries.length === 0" class="px-3 py-2 text-sm text-gray-500 dark:text-gray-400">
                                                        {{ __('common.no_results') }}
                                                    </li>
                                                </ul>
                                            </div>
                                        </template>
                                    </div>
                                </div>
                                @error('flag')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <!-- RTL Toggle -->
                            <div>
                                <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('admin.rtl_support') }}
                                </label>
                                <label class="inline-flex items-center cursor-pointer">
                                    <input type="checkbox"
                                           wire:model="isRtl"
                                           class="sr-only peer">
                                    <div class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-blue-300 dark:peer-focus:ring-blue-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-blue-600"></div>
                                    <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                        {{ __('admin.rtl_enabled') }}
                                    </span>
                                </label>
                                <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">{{ __('admin.rtl_description') }}</p>
                            </div>

                            <!-- Status -->
                            <div>
                                <label for="status" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                                    {{ __('common.status') }} <span class="text-red-500">*</span>
                                </label>
                                <select wire:model="status"
                                        id="status"
                                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500">
                                    <option value="active">{{ __('common.active') }}</option>
                                    <option value="inactive">{{ __('common.inactive') }}</option>
                                </select>
                                @error('status')
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>

                        @if(!$languageId)
                        <div class="p-4 bg-blue-50 dark:bg-blue-900/20 rounded-lg">
                            <div class="flex">
                                <svg class="flex-shrink-0 w-5 h-5 text-blue-700 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                                </svg>
                                <div class="ms-3 text-sm text-blue-700 dark:text-blue-400">
                                    <p>{!! __('admin.translation_files_auto_created', ['path' => '<code class="font-mono bg-blue-100 dark:bg-blue-800 px-1 rounded">lang/' . ($code ?: '{code}') . '/</code>']) !!}</p>
                                </div>
                            </div>
                        </div>
                        @endif
                    </div>

                    <!-- Modal footer -->
                    <div class="flex items-center justify-end gap-2 pt-4 border-t border-gray-200 dark:border-gray-700">
                        <button type="button"
                                wire:click="closeModal"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 dark:bg-gray-700 dark:text-gray-300 dark:border-gray-600 dark:hover:bg-gray-600">
                            {{ __('common.cancel') }}
                        </button>
                        @if(config('app.demo'))
                            <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}"
                                    class="px-4 py-2 text-sm font-medium text-white bg-blue-700 rounded-lg dark:bg-blue-600 cursor-not-allowed opacity-50">
                                {{ __('common.submit') }}
                            </button>
                        @else
                            <button type="submit"
                                    class="px-4 py-2 text-sm font-medium text-white bg-blue-700 rounded-lg hover:bg-blue-800 focus:ring-4 focus:outline-hidden focus:ring-blue-300 dark:bg-blue-600 dark:hover:bg-blue-700 dark:focus:ring-blue-800">
                                {{ __('common.submit') }}
                            </button>
                        @endif
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
