<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => 'Basic Information',
        'basic_information_description' => 'Essential details about your app',
        'app_name' => 'App name',
        'app_name_placeholder' => 'My Awesome App',
        'app_name_help' => 'Displayed on device home screen',
        'website_url' => 'Website URL',
        'website_url_placeholder' => 'https://example.com',
        'website_url_help' => 'Full URL of your website or web app',
        'configuration' => 'Configuration',
        'configuration_description' => 'Technical settings and identifiers',
        'app_id' => 'APP ID',
        'app_id_tooltip' => 'Unique package identifier used by app stores',
        'app_id_placeholder' => 'com.example.app',
        'app_id_help' => 'App ID cannot be changed once created',
        'copy' => 'Copy',
        'copied' => 'Copied!',
        'screen_orientation' => 'Screen orientation',
        'screen_orientation_help' => 'Controls how your app rotates on device',
        'orientation_system' => 'System',
        'orientation_portrait' => 'Portrait',
        'orientation_landscape' => 'Landscape',
        'app_language' => 'App language (ISO code)',
        'app_language_help' => 'Primary language for your app content',
    ],

    // Design Settings
    'design' => [
        'layout_template' => 'Layout Template',
        'layout_template_description' => 'Choose the navigation structure for your app',
        'layout_app_bar_drawer' => 'App Bar + Drawer',
        'layout_app_bar_tabs' => 'App Bar + Navigation Tabs',
        'layout_app_bar' => 'App Bar',
        'layout_blank' => 'Blank',
        'progress_indicator' => 'Progress Indicator',
        'progress_indicator_help' => 'Loading indicator style shown when pages are loading',
        'progress_disable' => 'Disable',
        'progress_linear' => 'Linear',
        'progress_circular' => 'Circular',
        'progress_indicator_color' => 'Progress Indicator Color',
        'progress_indicator_color_help' => 'Color of the loading progress indicator',
        'show_app_bar_title' => 'Show current webpage title in the app bar',
        'show_app_bar_title_help' => "Display the current page's title in the top bar",
        'nav_tab_icon_colors' => 'Navigation Tab Icon Colors',
        'nav_tab_icon_colors_help' => 'Color of inactive tab icons in light and dark mode',
        'active_tab_colors' => 'Active Tab Colors',
        'active_tab_colors_help' => 'Color of the selected tab in light and dark mode',
        'light_mode' => 'Light Mode',
        'dark_mode' => 'Dark Mode',
        'theme_colors' => 'Theme Colors',
        'theme_colors_description' => "Primary colors that define your app's appearance",
        'theme_color' => 'Theme Color',
        'theme_color_help' => 'Main color used throughout your app',
        'enable_dynamic_colors' => 'Enable Material You Dynamic Colors (Android 12+)',
        'enable_dynamic_colors_help' => "When enabled, your app will adapt colors from the user's wallpaper on Android 12+ devices. This overrides the theme color above.",
        'text_color_light' => 'Text Color (Light Mode)',
        'text_color_light_help' => 'Default text and icon color in light mode',
        'text_color_dark' => 'Text Color (Dark Mode)',
        'text_color_dark_help' => 'Default text and icon color in dark mode',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => 'App Icon',
        'app_icon_description' => 'Upload your app icon as a ZIP file from icon.kitchen',
        'current_icon' => 'Current Icon',
        'icon_zip_uploaded' => 'Icon ZIP uploaded',
        'icon_zip_uploaded_description' => 'Extracted icons are available for Android and Web platforms',
        'default_icon' => 'Default Icon',
        'default_icon_description' => 'Upload a custom icon to replace the default',
        'delete' => 'Delete',
        'upload_zip_file' => 'Upload ZIP File',
        'upload_zip_help' => 'ZIP file from icon.kitchen (MAX. 10MB)',
        'how_to_create' => 'How to create your icon:',
        'step_visit' => 'Visit',
        'step_design' => 'Design your app icon',
        'step_download' => 'Download the ZIP file containing all platform icons',
        'step_upload' => 'Upload the ZIP file here',
        'zip_file_info' => 'The ZIP file should contain icons for Android and Web platforms (Max 10MB)',
        'upload_icon' => 'Upload Icon',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => 'Splashscreen Appearance',
        'appearance_description' => 'Customize background, display duration, and animation effects',
        'background_type' => 'Background Type',
        'background_type_color' => 'Solid Color',
        'background_type_image' => 'Background Image',
        'background_color' => 'Background Color',
        'background_image' => 'Background Image',
        'background_image_help' => 'PNG only (MAX. 2MB)',
        'delete_background_image' => 'Delete Background Image',
        'display_duration' => 'Display Duration:',
        'seconds' => 'seconds',
        'animation_effect' => 'Animation Effect',
        'animation_fade' => 'Fade',
        'animation_slide' => 'Slide',
        'animation_zoom' => 'Zoom',
        'animation_none' => 'None',
        'branding' => 'Splashscreen Branding',
        'branding_description' => 'Add logo, title, subtitle, and text styling to your splashscreen',
        'show_logo' => 'Show Logo on Splashscreen',
        'logo_image' => 'Logo Image',
        'logo_image_help' => 'PNG with transparency recommended (MAX. 2MB)',
        'delete_logo' => 'Delete Logo',
        'logo_size' => 'Logo Size:',
        'logo_size_small' => 'Small (60dp)',
        'logo_size_medium' => 'Medium (150dp)',
        'logo_size_large' => 'Large (240dp)',
        'logo_size_help' => 'Adjust logo size for optimal appearance',
        'title' => 'Title',
        'title_placeholder' => 'My Awesome App',
        'subtitle' => 'Subtitle',
        'subtitle_placeholder' => 'Welcome to the best app ever',
        'text_theme' => 'Text Theme',
        'text_theme_light' => 'Light (White text)',
        'text_theme_dark' => 'Dark (Black text)',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => 'Drawer Appearance',
        'appearance_description' => 'Customize the background and visual style of your navigation drawer',
        'drawer_mode' => 'Drawer Mode',
        'drawer_mode_help' => 'Choose how the drawer background should appear',
        'mode_default' => 'Default (Theme Color)',
        'mode_color' => 'Custom Color',
        'mode_image' => 'Background Image',
        'background_color' => 'Background Color',
        'background_color_help' => 'Custom background color for the drawer',
        'background_image' => 'Background Image',
        'background_image_help' => 'PNG only (MAX. 2MB). Recommended: 1080x1920px',
        'delete_background_image' => 'Delete Background Image',
        'branding' => 'Drawer Branding',
        'branding_description' => 'Add logo, title, and customize text appearance in the drawer header',
        'show_logo' => 'Show Logo in Drawer',
        'show_logo_help' => 'Display a logo in the drawer header',
        'logo_light' => 'Drawer Logo (Light Mode)',
        'logo_light_help' => 'PNG with transparency required (MAX. 2MB) - Shown when app is in light theme',
        'delete_light_logo' => 'Delete Light Logo',
        'logo_dark' => 'Drawer Logo (Dark Mode)',
        'logo_dark_help' => 'PNG with transparency required (MAX. 2MB) - Shown when app is in dark theme',
        'delete_dark_logo' => 'Delete Dark Logo',
        'logo_size' => 'Logo Size:',
        'logo_size_small' => 'Small (40dp)',
        'logo_size_medium' => 'Medium (120dp)',
        'logo_size_large' => 'Large (200dp)',
        'logo_size_help' => 'Adjust logo size for optimal appearance',
        'drawer_title' => 'Drawer Title',
        'drawer_title_placeholder' => 'My App',
        'drawer_title_help' => 'Title displayed in drawer header',
        'drawer_subtitle' => 'Drawer Subtitle',
        'drawer_subtitle_placeholder' => 'Welcome to my app',
        'drawer_subtitle_help' => 'Subtitle or tagline shown below the title',
        'text_theme' => 'Text Theme',
        'text_theme_help' => 'Text color for drawer header and menu items',
        'text_theme_light' => 'Light (White text)',
        'text_theme_dark' => 'Dark (Black text)',
        'item_colors' => 'Drawer Item Colors',
        'item_colors_description' => 'Customize icon and text colors for drawer menu items',
        'item_icon_colors' => 'Drawer Item Icon Colors',
        'item_icon_colors_help' => 'Color of inactive drawer item icons and text in light and dark mode',
        'active_item_colors' => 'Active Item Colors',
        'active_item_colors_help' => 'Color of the selected/active drawer item in light and dark mode',
        'light_mode' => 'Light Mode',
        'dark_mode' => 'Dark Mode',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => 'Bottom Navigation Bar',
        'bottom_nav_bar_description' => 'Configure bottom navigation tab items (max 8 items)',
        'add_item' => '+ Add Item',
        'no_navigation_items' => 'No navigation items configured',
        'add_first_navigation_item' => 'Add your first navigation item',
        'home_tab_badge' => 'Home Tab - Synced to Main URL',
        'home_item_badge' => 'Home Item - Synced to Main URL',
        'label' => 'Label',
        'label_placeholder_home' => 'Home',
        'label_placeholder_about' => 'About Us',
        'action_type' => 'Action Type',
        'action_internal' => 'Internal Link',
        'action_external' => 'External Link',
        'action_hosted_page' => 'Hosted Page',
        'action_share' => 'Share',
        'action_email' => 'Send Email',
        'action_call' => 'Make a Call',
        'url' => 'URL',
        'email_address' => 'Email Address',
        'phone_number' => 'Phone Number',
        'hosted_page' => 'Hosted Page',
        'select_page' => 'Select a page',
        'synced_from_general' => 'Automatically synced from General Settings',
        'icon' => 'Icon',
        'select_icon' => 'Select Icon',
        'search_icons' => 'Search icons...',
        'home_tab_cannot_delete' => 'Home tab cannot be deleted',
        'home_item_cannot_delete' => 'Home item cannot be deleted',
        'max_navigation_items' => 'Maximum of 8 navigation items reached (excluding Home tab)',
        'app_bar_buttons' => 'App Bar Buttons',
        'app_bar_buttons_description' => 'Add action buttons to top right of app bar (max 3 buttons)',
        'add_button' => '+ Add Button',
        'no_app_bar_buttons' => 'No app bar buttons configured',
        'add_first_app_bar_button' => 'Add your first app bar button',
        'max_app_bar_buttons' => 'Maximum of 3 app bar buttons reached',
        'drawer_menu_items' => 'Drawer Menu Items',
        'drawer_menu_items_description' => 'Configure navigation drawer menu items (1 home + up to 9 additional items)',
        'no_drawer_items' => 'No drawer menu items configured',
        'add_first_drawer_item' => 'Add your first drawer menu item',
        'max_drawer_items' => 'Maximum of 9 additional items reached (10 total including home item)',
        'behavior_settings' => 'Behavior Settings',
        'behavior_settings_description' => 'Configure user interactions',
        'pull_to_refresh' => 'Pull to Refresh',
        'pull_to_refresh_description' => 'Allow users to refresh content by pulling down',
        'swipe_navigation' => 'Swipe Navigation',
        'swipe_navigation_description' => 'Allow users to navigate back by swiping from edge',
        'swipe_navigation_disabled' => 'Disabled for drawer layouts to prevent gesture conflicts',
        'preserve_tab_state' => 'Preserve Tab State',
        'preserve_tab_state_description' => 'Keep current page when switching between tabs/drawer items',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => 'App settings',
        'general' => 'General',
        'design' => 'Design',
        'icon' => 'Icon',
        'splashscreen' => 'Splashscreen',
        'navigation' => 'Navigation',
        'drawer' => 'Drawer',
        'webview' => 'WebView',
        'permissions' => 'Permissions',
        'custom_code' => 'Custom Code',
        'hosted_pages' => 'Hosted Pages',
        'notifications' => 'Notifications',
        'deployment' => 'Deployment',
        'builds' => 'Builds',
        'signing' => 'Signing',
        'back_to_apps' => 'Back to Apps',
    ],

    // WebView Settings
    'webview_user_agent_title' => 'User Agent',
    'webview_user_agent_description' => 'Customize the browser user agent string',
    'webview_custom_user_agent' => 'Custom User Agent',
    'webview_user_agent_placeholder' => 'Leave empty to use the default Android WebView user agent',
    'webview_user_agent_helper' => 'Optional. Override the default user agent sent to your website.',
    'webview_features_title' => 'WebView Features',
    'webview_features_description' => 'Configure browser capabilities and behavior',
    'webview_enable_javascript' => 'Enable JavaScript',
    'webview_enable_javascript_description' => 'Allow JavaScript execution in the WebView',
    'webview_enable_dom_storage' => 'Enable DOM Storage',
    'webview_enable_dom_storage_description' => 'Allow localStorage and sessionStorage APIs',
    'webview_enable_zoom_controls' => 'Enable Zoom Controls',
    'webview_enable_zoom_controls_description' => 'Allow pinch-to-zoom and zoom controls',
    'webview_enable_cache' => 'Enable Cache',
    'webview_enable_cache_description' => 'Cache web content for faster loading',

    // Permissions Settings
    'permissions_location_title' => 'Location Permission',
    'permissions_location_description' => 'Access device GPS for location-based features',
    'permissions_enable_location' => 'Enable Location Access',
    'permissions_location_helper' => 'Required for maps, location-based content, and geofencing features.',
    'permissions_show_code_example' => 'Show code example',
    'permissions_hide_code_example' => 'Hide code example',
    'permissions_javascript_example' => 'JavaScript Example:',
    'permissions_camera_title' => 'Camera Permission',
    'permissions_camera_description' => 'Access device camera for photos and video',
    'permissions_enable_camera' => 'Enable Camera Access',
    'permissions_camera_helper' => 'Required for taking photos, scanning QR codes, and video calls.',
    'permissions_storage_title' => 'Storage Permission',
    'permissions_storage_description' => 'Access device storage for file uploads and downloads',
    'permissions_enable_storage' => 'Enable Storage Access',
    'permissions_storage_helper' => 'Required for file uploads, image picker, and downloading files.',
    'permissions_microphone_title' => 'Microphone Permission',
    'permissions_microphone_description' => 'Access device microphone for audio recording',
    'permissions_enable_microphone' => 'Enable Microphone Access',
    'permissions_microphone_helper' => 'Required for voice recording, audio calls, and speech recognition.',
    'permissions_contacts_title' => 'Contacts Permission',
    'permissions_contacts_description' => 'Access device contacts for social features',
    'permissions_enable_contacts' => 'Enable Contacts Access',
    'permissions_contacts_helper' => 'Required for contact picker, invite features, and social integrations.',
    'permissions_vibrate_title' => 'Vibration Permission',
    'permissions_vibrate_description' => 'Access device vibration motor for haptic feedback',
    'permissions_enable_vibrate' => 'Enable Vibration',
    'permissions_vibrate_helper' => 'Required for haptic feedback and notification vibrations.',

    // Custom Code Settings
    'custom_code_access_required_title' => 'Upgrade Required',
    'custom_code_access_required_description' => 'Your current plan does not include custom code injection. Upgrade to access this feature and add custom CSS and JavaScript to your app.',
    'custom_code_upgrade_plan' => 'Upgrade your plan',
    'custom_code_enable_feature' => 'to enable this feature.',
    'custom_code_css_title' => 'Custom CSS',
    'custom_code_css_description' => 'Add custom styles to personalize your app appearance',
    'custom_code_css_label' => 'CSS Code',
    'custom_code_css_helper' => 'Maximum 100KB. CSS will be injected into every page.',
    'custom_code_js_title' => 'Custom JavaScript',
    'custom_code_js_description' => 'Add custom scripts for extended functionality',
    'custom_code_js_label' => 'JavaScript Code',
    'custom_code_js_helper' => 'Maximum 100KB. JavaScript will be executed in the webview.',

    // Notifications Settings
    'notifications_title' => 'Notifications',
    'notifications_description' => 'Configure Firebase Cloud Messaging (FCM) for notifications',
    'notifications_enable' => 'Enable Notifications',
    'notifications_firebase_service_account' => 'Firebase Service Account',
    'notifications_firebase_service_account_description' => 'Used by the server to send notifications via FCM API',
    'notifications_firebase_help_text' => 'JSON file (MAX. 2MB)',
    'notifications_delete_firebase_credentials' => 'Delete Firebase Credentials',
    'notifications_delete_firebase_credentials_confirm' => 'Are you sure you want to delete the Firebase credentials file?',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Required for Android app configuration',
    'notifications_google_services_help_text' => 'JSON file (MAX. 1MB)',
    'notifications_delete_google_services' => 'Delete Google Services File',
    'notifications_delete_google_services_confirm' => 'Are you sure you want to delete the Google Services file?',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Android Keystores',
        'generate_new' => 'Generate New',
        'upload_existing' => 'Upload Existing',
        'default_badge' => 'Default',
        'alias' => 'Alias',
        'alias_placeholder' => 'my-key-alias',
        'auto_generated' => 'Auto-generated',
        'created' => 'Created',
        'set_as_default' => 'Set as Default',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'no_keystores' => 'No Android keystores yet. Generate a new key or upload an existing one.',
        'upload_signing_key' => 'Upload Signing Key',
        'android_keystore_upload' => 'Android Keystore Upload',
        'keystore_name' => 'Keystore Name',
        'keystore_name_placeholder' => 'My Release Keystore',
        'keystore_file' => 'Keystore File',
        'keystore_file_help' => '.jks, .keystore, or .ks file (Max 5MB)',
        'upload_custom_key' => 'Upload custom key',
        'upload_custom_key_help' => 'Uncheck this if using auto-generated debug keystore',
        'password' => 'Password',
        'password_placeholder' => '••••••••',
        'password_help' => 'Used for both keystore and key access',
        'cancel' => 'Cancel',
        'upload' => 'Upload',
        'edit_keystore' => 'Edit Keystore',
        'update_password' => 'Update password',
        'save' => 'Save',
        'delete_keystore' => 'Delete Keystore',
        'delete_confirmation' => 'Are you sure you want to delete',
        'action_cannot_be_undone' => 'This action cannot be undone.',

        // Keystore Generator Modal
        'generate_signing_key' => 'Generate Signing Key',
        'generate_android_keystore' => 'Generate Android Keystore',
        'generate_keystore_description' => 'A new JKS keystore will be generated securely on the build server',
        'keystore_name_generate_placeholder' => 'My App Release Key',
        'key_alias' => 'Key Alias',
        'key_alias_placeholder' => 'my-app-key',
        'key_alias_help' => 'Must start with a letter. Letters, numbers, hyphens, and underscores allowed.',
        'password_settings' => 'Password Settings',
        'keystore_password' => 'Keystore Password',
        'min_characters_placeholder' => 'Min. 6 characters',
        'use_same_password' => 'Use same password for key and keystore',
        'key_password' => 'Key Password',
        'validity_period' => 'Validity Period',
        'years_10' => '10 years',
        'years_15' => '15 years',
        'years_20' => '20 years',
        'years_25_recommended' => '25 years (Recommended)',
        'years_30' => '30 years',
        'validity_help' => 'Google Play requires at least 25 years validity for new apps',
        'certificate_details' => 'Certificate Details (Optional)',
        'common_name' => 'Common Name (CN)',
        'common_name_placeholder' => 'Your app or organization name',
        'organization' => 'Organization (O)',
        'organization_placeholder' => 'Company Name',
        'organizational_unit' => 'Organizational Unit (OU)',
        'organizational_unit_placeholder' => 'Mobile Apps',
        'city' => 'City (L)',
        'city_placeholder' => 'San Francisco',
        'state' => 'State (ST)',
        'state_placeholder' => 'CA',
        'country' => 'Country (C)',
        'country_placeholder' => 'US',
        'save_password_warning' => 'Important: Save your password securely!',
        'save_password_description' => "The keystore will be encrypted and stored. You'll need the password for future builds. There is no way to recover a lost password.",
        'generating' => 'Generating...',
        'generate_keystore' => 'Generate Keystore',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => 'Hosted Pages Access Required',
        'upgrade_description' => 'Your current plan does not include hosted pages. Upgrade your plan to create custom pages that are hosted by us.',
        'upgrade_plan' => 'Upgrade your plan',
        'upgrade_suffix' => 'to enable this feature.',
        'table_page' => 'Page',
        'table_status' => 'Status',
        'table_created' => 'Created',
        'table_actions' => 'Actions',
        'status_published' => 'Published',
        'status_draft' => 'Draft',
        'edit' => 'Edit',
        'delete' => 'Delete',
        'no_pages' => 'No pages yet',
        'no_pages_description' => 'Click "Add Page" to create your first hosted page.',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => 'Create Page',
        'edit_page' => 'Edit Page',
        'title' => 'Title',
        'title_placeholder' => 'Page title',
        'slug' => 'Slug',
        'slug_placeholder' => 'page-slug',
        'start_from_template' => 'Start from template',
        'status' => 'Status',
        'status_help' => 'Only published pages are accessible in the app',
        'cancel' => 'Cancel',
        'save_changes' => 'Save Changes',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => 'My WordPress App',
        'wordpress_site_url' => 'WordPress Site URL',
        'wordpress_site_url_placeholder' => 'https://myblog.wordpress.com',
        'wordpress_site_url_help' => 'Enter your WordPress.com site URL (e.g., myblog.wordpress.com)',
        'app_id_placeholder' => 'com.example.wordpress',
        'package_name_help' => 'Unique identifier in reverse domain format (e.g., com.company.wordpress). Cannot be changed after creation.',

        // Design Settings
        'post_list_style' => 'Post List Style',
        'style_list' => 'List',
        'style_grid' => 'Grid',
        'style_magazine' => 'Magazine',
        'post_list_style_help' => 'How posts are displayed in the app',
        'progress_indicator_help' => 'Loading indicator style shown when fetching posts',
        'show_app_bar_title' => 'Show app name in the app bar',
        'show_app_bar_title_help' => "Display your app's name in the top bar",
        'nav_tab_icon_colors_help' => 'Color of inactive tab icons',
        'active_tab_colors_help' => 'Color of the selected tab',
        'theme_color_help' => 'Main color used throughout your app (WordPress blue: #21759B)',
        'dynamic_colors_help' => "When enabled, your app will adapt colors from the user's wallpaper on Android 12+ devices.",
        'layout_list_only' => 'List Only',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => 'My WordPress App',
        'splashscreen_subtitle_placeholder' => 'Welcome to the best blog app ever',

        // Sidebar
        'content' => 'Content',
        'features' => 'Features',

        // Drawer Settings
        'drawer_appearance_description' => 'Customize the navigation drawer background',
        'drawer_branding_description' => 'Logo, title, and text styling',
        'logo_light_mode' => 'Logo (Light Mode)',
        'logo_dark_mode' => 'Logo (Dark Mode)',
        'png_transparency_help' => 'PNG with transparency (MAX. 2MB)',
        'delete_background' => 'Delete Background',
        'drawer_title_placeholder' => 'My WordPress App',
        'drawer_subtitle_placeholder' => 'Your tagline here',
        'item_colors_description' => 'Icon and text colors for menu items',
        'inactive_item_colors' => 'Inactive Item Colors',

        // Navigation Settings
        'bottom_nav_tabs' => 'Bottom Navigation Tabs',
        'bottom_nav_tabs_description' => 'Configure bottom navigation items (max 8 + home)',
        'add_tab' => '+ Add Tab',
        'home_tab_shows_all_posts' => 'Home Tab - Shows All Posts',
        'home_item_shows_all_posts' => 'Home Item - Shows All Posts',
        'tab_name_placeholder' => 'Tab Name',
        'menu_item_placeholder' => 'Menu Item',
        'action_category' => 'Category',
        'action_tag' => 'Tag',
        'action_search' => 'Search',
        'action_bookmarks' => 'Bookmarks',
        'action_share' => 'Share',
        'category_slug' => 'Category Slug',
        'tag_slug' => 'Tag Slug',
        'category_slug_placeholder' => 'technology',
        'tag_slug_placeholder' => 'featured',
        'app_bar_buttons_description' => 'Action buttons in the top right (max 3)',
        'no_app_bar_buttons_description' => 'No app bar buttons configured. Add search, share, or other quick actions.',
        'search_placeholder' => 'Search',
        'drawer_menu_items_description' => 'Navigation drawer menu items (1 home + up to 9 items)',
        'swipe_navigation_description' => 'Navigate back by swiping from edge',
        'preserve_tab_state_description' => 'Keep scroll position when switching tabs',

        // Content Settings
        'post_display' => 'Post Display',
        'post_display_description' => 'Configure how posts are displayed in your app',
        'posts_per_page' => 'Posts Per Page',
        'posts_per_page_help' => 'Number of posts to load at a time (1-50)',
        'excerpt_length' => 'Excerpt Length (characters)',
        'excerpt_length_help' => 'Maximum characters shown in post excerpts (50-500)',
        'post_metadata' => 'Post Metadata',
        'post_metadata_description' => 'Choose what information to display with each post',
        'show_featured_image' => 'Show featured image',
        'show_featured_image_help' => "Display the post's featured/thumbnail image",
        'show_excerpt' => 'Show post excerpt',
        'show_excerpt_help' => 'Display a preview of the post content',
        'show_author' => 'Show author name',
        'show_author_help' => 'Display the author who wrote the post',
        'show_date' => 'Show publish date',
        'show_date_help' => 'Display when the post was published',
        'show_categories' => 'Show categories',
        'show_categories_help' => 'Display the categories assigned to the post',
        'show_reading_time' => 'Show estimated reading time',
        'show_reading_time_help' => 'Display how long it takes to read the post',

        // Features Settings
        'core_features' => 'Core Features',
        'core_features_description' => 'Enable or disable app functionality',
        'enable_search' => 'Enable search',
        'enable_search_help' => 'Allow users to search for posts in your app',
        'enable_comments' => 'Enable comments',
        'enable_comments_help' => 'Allow users to view and post comments on articles',
        'enable_bookmarks' => 'Enable bookmarks',
        'enable_bookmarks_help' => 'Allow users to save posts for later reading',
        'enable_share' => 'Enable sharing',
        'enable_share_help' => 'Allow users to share posts via other apps',
        'advanced_features' => 'Advanced Features',
        'advanced_features_description' => 'Additional functionality for enhanced user experience',
        'enable_offline_reading' => 'Enable offline reading',
        'enable_offline_reading_help' => 'Cache posts for reading without internet connection',
        'enable_user_auth' => 'Enable user authentication',
        'enable_user_auth_help' => 'Allow users to sign in with their WordPress.com account',
        'enable_push_notifications' => 'Enable push notifications',
        'enable_push_notifications_help' => 'Send notifications when new posts are published',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => 'Search builds...',
        'filter' => 'Filter',
        'platform_filter' => 'Platform',
        'status_filter' => 'Status',
        'android' => 'Android',
        'completed' => 'Completed',
        'building' => 'Building',
        'failed' => 'Failed',
        'pending' => 'Pending',
        'table_platform' => 'Platform',
        'table_build_info' => 'Build Info',
        'table_created' => 'Created',
        'table_actions' => 'Actions',
        'release' => 'Release',
        'debug' => 'Debug',
        'download' => 'Download',
        'preview' => 'Preview',
        'logs' => 'Logs',
        'delete' => 'Delete',
        'no_builds' => 'No builds found',

        // Build Modal
        'create_new_build' => 'Create New Build',
        'platform_label' => 'Platform',
        'build_costs_credit' => 'Build costs :count credit|Build costs :count credits',
        'build_type_label' => 'Build Type',
        'for_testing' => 'For testing',
        'for_production' => 'For production',
        'output_format_label' => 'Output Format',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'For testing/sideloading',
        'for_google_play_store' => 'For Google Play Store',
        'builder_label' => 'Builder',
        'auto_select_recommended' => 'Auto-select (recommended)',
        'auto_select_help' => 'Leave as "Auto-select" to use the least busy builder, or choose a specific builder.',
        'no_builders_available' => 'No builders available!',
        'no_builders_help' => 'Your plan does not have access to any builders. Please contact support or upgrade your plan.',
        'signing_key_label' => 'Signing Key',
        'select_keystore' => 'Select a keystore',
        'no_keystores_available' => 'No keystores available.',
        'upload_in_signing_section' => 'Upload one in the Signing section',
        'signing_key_required' => 'Signing key required!',
        'version_name_label' => 'Version Name',
        'version_name_help' => 'Format: X.Y or X.Y.Z (e.g., 1.0 or 1.0.0). Auto-incremented for each platform.',
        'build_number_label' => 'Build Number',
        'next_build_number' => 'Next Build Number',
        'build_number_auto_increment' => 'Build number automatically increments with each build',
        'build_cost_info' => 'This build will cost :count credit|This build will cost :count credits',
        'build_email_notification' => "You'll receive an email when the build is ready to download.",
        'cancel' => 'Cancel',
        'start_build' => 'Start Build',
        'credit' => 'credit',
        'credits' => 'credits',
        'builder_info' => 'Builder:',

        // Build Logs Modal
        'build_logs' => 'Build Logs',
        'duration' => 'Duration:',
        'no_logs_available' => 'No logs available for this build',
        'error' => 'Error:',
        'close' => 'Close',
        'download_build' => 'Download Build',

        // Build Download Modal
        'download_build_title' => 'Download Build',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => 'This is an AAB file which cannot be directly installed on devices. AAB files are designed for upload to Google Play Console, where Google will generate optimized APKs for users.',
        'scan_with_android' => 'Scan with your Android device',
        'qr_unavailable' => 'QR code unavailable',
        'download_options' => 'Download Options',
        'download_options_description' => 'Scan the QR code with your mobile device or use the direct download link below.',
        'download_format' => 'Download :format',
        'installation_note' => 'Installation:',
        'installation_help' => 'You may need to enable "Install from Unknown Sources" in your Android settings.',
        'download_aab_file' => 'Download AAB File',
        'upload_to_play_console' => 'Upload this file to Google Play Console to publish your app.',
        'next_steps' => 'Next Steps:',
        'next_steps_help' => 'Upload this AAB file to Google Play Console under Release > Production/Testing. Google will automatically generate optimized APKs for your users.',

        // Delete Build Modal
        'delete_build' => 'Delete Build',
        'delete_confirmation' => 'Are you sure you want to delete the',
        'build_suffix' => 'build?',
        'action_cannot_be_undone' => 'This action cannot be undone.',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => 'No Build Selected',
        'select_build_help' => 'Select a completed build from the Builds tab to preview it here',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => 'Website URL',
        'app_id' => 'APP ID',
        'app_id_tooltip' => 'Unique package identifier (cannot be changed after creation)',
        'auto_generate_package' => 'Auto-generate from app name',
        'package_name_help' => 'Unique identifier in reverse domain format (e.g., com.company.app). Cannot be changed after creation.',
        'theme_color' => 'Theme Color',
        'theme_color_help' => 'Main color used throughout your app. Text colors will use default black/white and can be customized later.',
        'layout_template' => 'Layout template',
        'layout_app_bar_drawer' => 'App Bar + Drawer',
        'layout_app_bar_tabs' => 'App Bar + Navigation Tabs',
        'layout_app_bar' => 'App Bar',
        'layout_blank' => 'Blank',
        'layout_help' => 'Choose the navigation structure for your app',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => 'Cancel',
        'delete' => 'Delete',
        'action_cannot_be_undone' => 'This action cannot be undone.',
        'delete_build' => 'Delete Build',
        'delete_build_confirmation' => 'Are you sure you want to delete the',
        'build_suffix' => 'build?',
        'delete_app_icon' => 'Delete App Icon',
        'delete_icon_confirmation' => 'Are you sure you want to delete the icon for',
        'delete_keystore' => 'Delete Keystore',
        'delete_keystore_confirmation' => 'Are you sure you want to delete',
        'delete_splashscreen_background' => 'Delete Splashscreen Background',
        'delete_splashscreen_background_confirmation' => 'Are you sure you want to delete the splashscreen background image for',
        'delete_splashscreen_logo' => 'Delete Splashscreen Logo',
        'delete_splashscreen_logo_confirmation' => 'Are you sure you want to delete the splashscreen logo for',
        'delete_drawer_background' => 'Delete Drawer Background',
        'delete_drawer_background_confirmation' => 'Are you sure you want to delete the drawer background image for',
        'delete_dark_mode_logo' => 'Delete Dark Mode Logo',
        'delete_dark_mode_logo_confirmation' => 'Are you sure you want to delete the drawer dark mode logo for',
        'delete_light_mode_logo' => 'Delete Light Mode Logo',
        'delete_light_mode_logo_confirmation' => 'Are you sure you want to delete the drawer light mode logo for',
        'delete_page' => 'Delete Page',
        'delete_page_confirmation' => 'Are you sure you want to delete',
        'delete_page_warning' => 'This action cannot be undone. If this page is used in your navigation, it will no longer be accessible.',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => 'Push Notifications',
        'description' => 'Configure Firebase Cloud Messaging for push notifications',
        'enable_label' => 'Enable push notifications',
        'enable_help' => 'Send notifications when new posts are published',
        'firebase_required_title' => 'Firebase Configuration Required',
        'firebase_required_description' => 'Upload both configuration files below to enable push notifications in your app.',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'File uploaded',
        'google_services_configured' => 'google-services.json is configured',
        'delete' => 'Delete',
        'delete_file_confirm' => 'Are you sure you want to delete this file?',
        'upload_google_services' => 'Upload google-services.json',
        'google_services_help' => 'Download from Firebase Console (MAX. 1MB)',
        'google_services_instructions' => 'Download from Firebase Console > Project Settings > Your apps > Android app',
        'firebase_service_account_label' => 'Firebase Service Account (for sending notifications)',
        'credentials_configured' => 'Credentials configured',
        'service_account_stored' => 'Service account is securely stored',
        'delete_credentials_confirm' => 'Are you sure you want to delete these credentials?',
        'upload_service_account' => 'Upload Service Account JSON',
        'service_account_help' => 'Download from Firebase Console (MAX. 2MB)',
        'service_account_instructions' => 'Download from Firebase Console > Project Settings > Service Accounts > Generate new private key',
        'setup_title' => 'How to set up Firebase:',
        'setup_step_1' => 'Go to',
        'setup_step_2' => 'Create a project or select an existing one',
        'setup_step_3' => 'Add an Android app with your package name:',
        'setup_step_4' => 'Download',
        'setup_step_4_suffix' => 'and upload it above',
        'setup_step_5' => 'Go to Project Settings > Service Accounts',
        'setup_step_6' => 'Generate a new private key and upload it above',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => ':section settings saved successfully!',
        'settings_save_failed' => 'Failed to save settings. Please try again.',

        // Design settings
        'design_saved' => 'Design settings saved successfully!',

        // Navigation settings
        'navigation_saved' => 'Navigation settings saved successfully!',
        'home_tab_cannot_delete' => 'Home tab cannot be deleted. It is required for navigation.',
        'home_tab_cannot_move' => 'Home tab must remain first and cannot be moved.',
        'cannot_move_below_home' => 'Cannot move items below the home tab.',
        'home_item_cannot_delete' => 'Home item cannot be deleted. It is required for navigation.',
        'home_item_cannot_move' => 'Home item must remain first and cannot be moved.',
        'cannot_move_below_home_item' => 'Cannot move items below the home item.',

        // Custom code
        'custom_code_saved' => 'Custom code saved successfully!',
        'custom_code_save_failed' => 'Failed to save custom code. Please try again.',
        'custom_code_no_access' => 'Your plan does not include custom code access. Please upgrade your plan.',

        // WebView settings
        'webview_saved' => 'WebView settings saved successfully!',

        // Permissions settings
        'permissions_saved' => 'Permissions saved successfully!',

        // Drawer settings
        'drawer_saved' => 'Drawer settings saved successfully!',

        // General settings
        'general_saved' => 'General settings saved successfully!',

        // Splashscreen settings
        'splashscreen_saved' => 'Splashscreen settings saved successfully!',

        // Icon settings
        'icon_uploaded' => 'App icon uploaded successfully!',
        'icon_upload_failed' => 'Failed to upload icon: :error',
        'icon_removed' => 'App icon removed successfully!',
        'icon_remove_failed' => 'Failed to remove icon. Please try again.',

        // Splashscreen modals
        'splashscreen_background_deleted' => 'Splashscreen background image deleted successfully!',
        'splashscreen_background_delete_failed' => 'Failed to delete background image. Please try again.',
        'splashscreen_logo_deleted' => 'Splashscreen logo deleted successfully!',
        'splashscreen_logo_delete_failed' => 'Failed to delete logo. Please try again.',

        // Drawer modals
        'drawer_background_deleted' => 'Drawer background image deleted successfully!',
        'drawer_background_delete_failed' => 'Failed to delete background image. Please try again.',
        'drawer_logo_deleted' => 'Drawer logo deleted successfully!',
        'drawer_logo_delete_failed' => 'Failed to delete logo. Please try again.',
        'drawer_logo_light_deleted' => 'Drawer light mode logo deleted successfully!',
        'drawer_logo_dark_deleted' => 'Drawer dark mode logo deleted successfully!',

        // Notifications settings
        'notifications_saved' => 'Notification settings saved successfully!',
        'firebase_credentials_deleted' => 'Firebase credentials deleted successfully!',
        'firebase_credentials_delete_failed' => 'Failed to delete Firebase credentials. Please try again.',
        'google_services_deleted' => 'Google Services file deleted successfully!',
        'google_services_delete_failed' => 'Failed to delete Google Services file. Please try again.',

        // Signing keys
        'keystore_updated' => 'Keystore updated successfully!',
        'keystore_update_failed' => 'Failed to update keystore.',
        'keystore_load_failed' => 'Failed to load keystore.',
        'keystore_deleted' => 'Keystore deleted successfully!',
        'keystore_delete_failed' => 'Failed to delete keystore. Please try again.',
        'keystore_uploaded' => 'Keystore uploaded successfully!',
        'keystore_upload_failed' => 'Failed to upload signing key: :error',
        'keystore_generated' => 'Keystore generated successfully!',
        'keystore_set_default' => 'Default keystore updated successfully!',

        // Build modal
        'build_no_builders_platform' => 'No builders available for the :platform platform. Please contact support or upgrade your plan.',
        'build_no_subscription' => 'You need an active subscription to build apps. Please subscribe to a plan.',
        'build_no_builders_plan' => 'No builders available for your plan. Please contact support or upgrade your plan.',
        'build_builder_not_available' => 'Selected builder is not available for your plan.',
        'build_builder_unavailable' => 'Selected builder is currently unavailable.',
        'build_builder_no_platform' => 'Selected builder does not support the :platform platform.',
        'build_insufficient_credits' => 'Insufficient build credits. This build requires :count credit(s). Please upgrade your plan or wait for monthly reset.',
        'build_keystore_required' => 'Android keystore is required for release builds. Please select a keystore.',
        'build_keystore_invalid' => 'Invalid keystore selected.',
        'build_already_in_progress' => 'A :platform build is already in progress. Please wait for it to complete.',
        'build_queued' => ':platform build queued successfully! Your build will be processed when a builder becomes available. (:credits credits remaining)',
        'build_queued_on_builder' => ':platform build queued successfully on :builder! (:credits credits remaining)',
        'build_create_failed' => 'Failed to create build: :error',
        'build_deleted' => 'Build deleted successfully!',
        'build_delete_failed' => 'Failed to delete build. Please try again.',

        // Hosted pages
        'hosted_page_saved' => 'Page saved successfully!',
        'hosted_page_save_failed' => 'Failed to save page. Please try again.',
        'hosted_page_deleted' => 'Page deleted successfully!',
        'hosted_page_delete_failed' => 'Failed to delete page. Please try again.',
        'hosted_page_limit_reached' => 'You have reached the maximum number of hosted pages for your plan.',
        'hosted_page_no_access' => 'Your current plan does not include hosted pages. Upgrade your plan to create custom pages.',

        // Additional toast keys for AndroidWordPress
        'features_saved' => 'Feature settings saved successfully!',
        'content_saved' => 'Content settings saved successfully!',
        'storage_link_missing' => 'Storage link not found. Run: php artisan storage:link',
        'splashscreen_image_deleted' => 'Splashscreen background image deleted successfully!',
        'splashscreen_image_delete_failed' => 'Failed to delete background image. Please try again.',
        'logo_delete_failed' => 'Failed to delete logo. Please try again.',
        'default_key_updated' => 'Default signing key updated successfully!',
        'default_key_update_failed' => 'Failed to update default signing key.',
        'keystore_uploaded_default' => 'Keystore uploaded and set as default!',
        'signing_key_upload_failed' => 'Failed to upload signing key: :error',
        'page_not_found' => 'Page not found.',
        'page_deleted' => 'Page deleted successfully!',
        'page_delete_failed' => 'Failed to delete page. Please try again.',
        'page_updated' => 'Page updated successfully!',
        'page_created' => 'Page created successfully!',
        'page_save_failed' => 'Failed to save page. Please try again.',
        'page_limit_reached' => "You've reached the maximum of :max pages for your plan.",
        'hosted_pages_not_available' => 'Your plan does not include hosted pages. Please upgrade your plan.',
        'unauthorized' => 'Unauthorized action.',
        'home_tab_required' => 'Home tab cannot be deleted. It is required for navigation.',
        'home_tab_first' => 'Home tab must remain first.',
        'home_item_required' => 'Home item cannot be deleted.',
        'build_no_builders' => 'No builders available for the :platform platform. Please contact support or upgrade your plan.',
        'build_no_plan_builders' => 'No builders available for your plan. Please contact support or upgrade your plan.',
        'build_builder_platform_unsupported' => 'Selected builder does not support the :platform platform.',
        'build_insufficient_credits' => 'Insufficient build credits. This build requires :credits credit(s). Please upgrade your plan or wait for monthly reset.',
        'build_invalid_keystore' => 'Invalid keystore selected.',
        'build_queued_no_builder' => ':platform build queued successfully! Your build will be processed when a builder becomes available. (:credits credits remaining)',
        'build_queued_success' => ':platform build queued successfully on :builder! (:credits credits remaining)',
        'available_builder' => 'available builder',
        'invalid_google_services_json' => 'Invalid JSON file. Please upload a valid google-services.json file.',
        'invalid_google_services_structure' => 'Invalid google-services.json. Missing required project_info or client section.',
        'invalid_firebase_service_account' => 'Invalid JSON file. Please upload a valid Firebase service account file.',
        'invalid_firebase_service_account_type' => 'Invalid Firebase service account file. Missing or invalid type field.',
        'settings_save_failed_error' => 'Failed to save settings: :error',
        'file_delete_failed' => 'Failed to delete file: :error',
        'credentials_delete_failed' => 'Failed to delete credentials: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => 'General',
        'general_description' => 'Basic information and configuration settings',
        'design' => 'Design',
        'design_description' => 'Customize layout, colors, and theme settings',
        'icon' => 'Icon',
        'icon_description' => 'Upload app icon for Android',
        'splashscreen' => 'Splashscreen',
        'splashscreen_description' => 'Configure startup screen appearance and animation',
        'navigation' => 'Navigation',
        'navigation_description' => 'Manage navigation items and app bar buttons',
        'drawer' => 'Drawer Settings',
        'drawer_description' => 'Customize drawer menu appearance and branding',
        'webview' => 'WebView Settings',
        'webview_description' => 'Configure WebView behavior and features',
        'permissions' => 'Permissions',
        'permissions_description' => 'Configure device permissions your app will request',
        'custom_code' => 'Custom Code',
        'custom_code_description' => 'Inject custom CSS and JavaScript into your app',
        'hosted_pages' => 'Hosted Pages',
        'hosted_pages_description' => 'Create custom HTML pages hosted by us for your app',
        'pages' => 'Pages',
        'add_page' => 'Add Page',
        'notifications' => 'Notifications',
        'notifications_description' => 'Configure Firebase Cloud Messaging for notifications',
        'builds' => 'Builds',
        'builds_description' => 'Generate Android APK and AAB files for deployment',
        'credits' => 'Credits',
        'new_build' => 'New Build',
        'signing' => 'Signing',
        'signing_description' => 'Manage signing keys for app distribution',
        // WordPress-specific sections
        'general_description_wordpress' => 'Basic information and WordPress site configuration',
        'content' => 'Content',
        'content_description' => 'Configure post display and content settings',
        'features' => 'Features',
        'features_description' => 'Enable or disable app features',
    ],

];
