<?php

namespace Database\Seeders;

use App\Models\AppBuilder;
use App\Services\PluginManager;
use Illuminate\Database\Seeder;

class AppBuilderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get all active platform IDs dynamically from PluginManager
        $pluginManager = app(PluginManager::class);
        $allPlatformIds = $pluginManager->getActivePlatforms()
            ->map(fn ($p) => $p->getPlatformId())
            ->values()
            ->toArray();

        // Create or update the default builder (TitanSystems hosted service)
        // This is a free service for script customers - server_key is dynamically
        // fetched from purchase_code via the model accessor
        AppBuilder::updateOrCreate(
            ['is_default' => true],
            [
                'name' => 'Default Builder',
                'url' => AppBuilder::DEFAULT_BUILDER_URL,
                'port' => AppBuilder::DEFAULT_BUILDER_PORT,
                'server_key' => 'dynamic', // Placeholder - actual key from purchase_code
                'max_queue' => 5,
                'platforms' => $allPlatformIds,
                'status' => 'active',
                'credit_cost' => 1,
            ]
        );
    }
}
