<?php

use App\Models\Language;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // All supported languages - uses firstOrCreate to avoid duplicates
        $languages = [
            [
                'name' => 'English',
                'code' => 'en',
                'flag' => 'us',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'Deutsch',
                'code' => 'de',
                'flag' => 'de',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => '日本語',
                'code' => 'ja',
                'flag' => 'jp',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'العربية',
                'code' => 'ar',
                'flag' => 'sa',
                'is_rtl' => true,
                'status' => 'active',
            ],
            [
                'name' => 'Français',
                'code' => 'fr',
                'flag' => 'fr',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => 'Bahasa Indonesia',
                'code' => 'id',
                'flag' => 'id',
                'is_rtl' => false,
                'status' => 'active',
            ],
            [
                'name' => '한국어',
                'code' => 'ko',
                'flag' => 'kr',
                'is_rtl' => false,
                'status' => 'active',
            ],
        ];

        foreach ($languages as $lang) {
            $language = Language::updateOrCreate(
                ['code' => $lang['code']],
                $lang
            );
            // Create translation files if they don't exist
            $language->createTranslationFiles();
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Only remove the newly added languages, not the original ones
        Language::whereIn('code', ['fr', 'id', 'ko'])->delete();
    }
};
